#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
    public class Messages_HL7AIOruMessage : BaseTest
	{
		#region Variables & Setup

		private static string _hl7Message;

		private HL7AIOruMessage _oruMessage;
	    

		static Messages_HL7AIOruMessage()
		{
            
		}

	    [SetUp]
	    public void SetUp()
	    {
	        _hl7Message = string.Concat(
	            "MSH|^~\\&|IM|589|VBECS|589|20080526135401-0500||ORU^R01|1048|P|2.4|6||AL|NE",
	            CARRIAGE_RETURN,
	            "OBR|1|2953060005^OR||TAS|||||||||||||||ProVueSanDiego",
	            CARRIAGE_RETURN,
	            "OBX|1||AntiA||4+||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|2||SC2||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|3||ABSInterp||Neg||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|4||Comment||Testing Comment||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|5||AntiB||3+||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|6||A1Cells||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|7||BCells||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|8||AntiD||4+||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|9||DControl||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|10||ABOInterp||AB||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|11||RhInterp||Pos||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN,
	            "OBX|12||SC1||0||||||F|||20151102085842||DNS   dobrak",
	            CARRIAGE_RETURN);
                _oruMessage = new HL7AIOruMessage(_hl7Message);
	    }

	    #endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
			HL7AIOruMessage oruTestMessage = new HL7AIOruMessage( _hl7Message );
			//
			Assert.IsTrue( oruTestMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7AIOruMessage oruMessage = new HL7AIOruMessage( null );
			//
			Assert.IsTrue( oruMessage != null );
		}

		#endregion

		#region Methods

		[Test]
		public void GetMessage_Pass()
		{
			Assert.IsNotNull( _oruMessage.GetMessage() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessage_Fail()
		{
		}

        [Test]
        public void GetMessageControlI_Pass()
        {
            Assert.IsNotNull(_oruMessage.GetMessageControlID());
        }

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageControlID_Fail()
		{
		}

		[Test]
		public void GetMessageType_Pass()
		{
			Assert.IsNotNull( _oruMessage.GetMessageType() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageType_Fail()
		{
		}

		[Test]
		public void IsResponseRequired_Pass()
		{
			Assert.IsTrue( _oruMessage.IsResponseRequired() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsResponseRequired_Fail()
		{
		}




        [Test]
        public void IsResponseRequiredTest()
        {
            // TODO: Implement unit test for IsResponseRequiredTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void GetMessageTest()
        {
            // TODO: Implement unit test for GetMessageTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void GetMessageControlIDTest()
        {
            // TODO: Implement unit test for GetMessageControlIDTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void GetMessageTypeTest()
        {
            // TODO: Implement unit test for GetMessageTypeTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void get_MessageTypeTest()
        {
            // TODO: Implement unit test for get_MessageTypeTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void get_MessageTest()
        {
            // TODO: Implement unit test for get_MessageTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void get_MessageControlIDTest()
        {
            // TODO: Implement unit test for get_MessageControlIDTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        void set_MessageControlIDTest()
        {
            // TODO: Implement unit test for set_MessageControlIDTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void get_DelimitersTest()
        {
            // TODO: Implement unit test for get_DelimitersTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void get_MshTest()
        {
            // TODO: Implement unit test for get_MshTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void get_ObrTest()
        {
            // TODO: Implement unit test for get_ObrTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        void get_ObxSegmentsTest()
        {
            // TODO: Implement unit test for get_ObxSegmentsTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void set_ObxSegmentsTest()
        {
            // TODO: Implement unit test for set_ObxSegmentsTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void get_UniversalServiceIDTest()
        {
            // TODO: Implement unit test for get_UniversalServiceIDTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void set_UniversalServiceIDTest()
        {
            // TODO: Implement unit test for set_UniversalServiceIDTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        void ToByteArrayTest()
        {
            // TODO: Implement unit test for ToByteArrayTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void ToByteArrayWithoutControlCharactersTest()
        {
            // TODO: Implement unit test for ToByteArrayWithoutControlCharactersTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void ToStringTest()
        {
            // TODO: Implement unit test for ToStringTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void EqualsTest()
        {
            // TODO: Implement unit test for EqualsTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void GetHashCodeTest()
        {
            // TODO: Implement unit test for GetHashCodeTest
        }

        [NUnit.Framework.TestAttribute()]
        [NUnit.Framework.IgnoreAttribute()]
        public void GetTypeTest()
        {
            // TODO: Implement unit test for GetTypeTest
        }
        #endregion

    }
}
#endif